IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[ADM_ERRO_EST_NF_SAI]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[ADM_ERRO_EST_NF_SAI](
	[CODIGO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
 CONSTRAINT [PK_ADM_ERRO_EST_NF_SAI] PRIMARY KEY CLUSTERED 
(
	[CODIGO] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_SAI_CODIGO]  DEFAULT ((0)) FOR [CODIGO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_SAI_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_SAI_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_SAI_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_NF_SAI_ADM_ERRO] FOREIGN KEY([CODIGO])
REFERENCES [dbo].[ADM_ERRO] ([CODIGO])

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] CHECK CONSTRAINT [FK_ADM_ERRO_EST_NF_SAI_ADM_ERRO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_NF_SAI_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_SAI] CHECK CONSTRAINT [FK_ADM_ERRO_EST_NF_SAI_EST_NF_SAI]
end